"use strict";
//
// Copyright 2023 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = require("crypto");
const ByteArray_1 = require("../internal/ByteArray");
const Native = require("../../../Native");
const Constants_1 = require("../internal/Constants");
const CallLinkAuthCredential_1 = require("./CallLinkAuthCredential");
class CallLinkAuthCredentialResponse extends ByteArray_1.default {
    constructor(contents) {
        super(contents, Native.CallLinkAuthCredentialResponse_CheckValidContents);
    }
    static issueCredential(userId, redemptionTime, params) {
        const random = (0, crypto_1.randomBytes)(Constants_1.RANDOM_LENGTH);
        return this.issueCredentialWithRandom(userId, redemptionTime, params, random);
    }
    static issueCredentialWithRandom(userId, redemptionTime, params, random) {
        return new CallLinkAuthCredentialResponse(Native.CallLinkAuthCredentialResponse_IssueDeterministic(userId.getServiceIdFixedWidthBinary(), redemptionTime, params.contents, random));
    }
    receive(userId, redemptionTime, params) {
        return new CallLinkAuthCredential_1.default(Native.CallLinkAuthCredentialResponse_Receive(this.contents, userId.getServiceIdFixedWidthBinary(), redemptionTime, params.contents));
    }
}
exports.default = CallLinkAuthCredentialResponse;
//# sourceMappingURL=CallLinkAuthCredentialResponse.js.map